/*#ifdef SKINNING

	#version 120
	#extension EXT_gpu_shader4 : enable          

#endif*/

#ifdef _VERSION_CHECK_
	#ifndef MSET

		#ifndef _NOT_INSTANCED_
		
			#version 120
			#extension GL_EXT_gpu_shader4 : enable          
			
		#endif
		
	#endif
#endif


#ifdef ALPHATEST

	#ifdef BSET
	//	varying float		distance;
		uniform float 		fade;
	#endif
	//uniform vec2		cull;
	varying float		alphaFade;

	#ifdef VEGETATION
		uniform float 	windStrenght;
		uniform vec3 	windVec;
		uniform float	time;
		uniform vec2 	meshbox;
		uniform vec2	bendMul;
		float 			freq=time/*+time*windStrenght*0.25*/;
		//uniform vec3 	prevcampos;
	#endif
				
#endif

#ifdef _HEIGHTMAP_
	
	uniform sampler2D	heightmap;
	uniform sampler2D	cmask;
	uniform vec2		invHeightmapSize;
	uniform vec2		tileDim;
	//uniform vec3		tilePos;	// tilepos
	uniform vec3		terrainDim; // width, depth and height of the terrain
 	uniform vec3		invTerrainDim;
	
	uniform vec3		WorldPoses[200];

	uniform vec2		baseTiles;
	uniform vec3		baseTexParams;
	varying mat3		TBN;
	varying vec3		vColor;
	varying float		vSlope;
	varying vec2		baseCoords;
	
#else

	#ifdef SKINNING

	/*	uniform mat3 	boneMatrices[100],
						prevBoneMatrices[100];
		*/				
		uniform samplerBuffer 	boneMatrices;
		uniform samplerBuffer 	prevBoneMatrices;
		//attribute vec4 		 	weights;
		//attribute vec4  		matrixIndices;

		varying mat3	TBN;
						
	#else
	
		#ifdef PSYSTEM

			uniform	vec4 	pparams[100]; 
			uniform vec4	prevPParams[100];
			
			vec4			tpos;
			uniform vec4	data;

			//attribute vec4	index;
			varying float 	life;

			uniform vec2	tofs;			// cambiare in uniform
			uniform vec2	tscale;
			//varying vec4	pnormal;
			varying float	cosa,
							sina;
			uniform vec3 	particleScale;
	
		#else

			#ifdef BSET

				//uniform	mat4 	pparams[100];
				
				//uniform float pparams[1000];
				uniform 		samplerBuffer 	pparams;
				//uniform vec4 pparams[300];
				vec4			tpos;
				uniform vec4	data;
				//attribute vec4	index;
				varying vec4	pnormal;
				varying vec4 	pcolor;
				
				uniform vec3	campos;
				
			#else
	
				#ifdef MSET

					uniform	mat4 	pparams[/*64*/60];
					
					vec4		tpos;
					//attribute vec3 	index;
					
					//varying vec3 	pcolor;
				
				#else
				
					#ifndef _NOT_INSTANCED_
					
						uniform samplerBuffer 		WorldPoses;
						uniform samplerBuffer 		prevWorldPoses;
					
					#endif
					
				#endif
		
				varying mat3	TBN;

			#endif

		#endif
						
	#endif
	
#endif

varying vec2 			texcoord;

//attribute vec3 			normal;
attribute vec4			binormal; 
						
vec4 					outNormal,
						outTangent,
						outBinormal; 

varying vec4 	curpos,
				pos, 
				prev;
uniform mat4	prevMVM,
		prevWTM/*,
		WTM*/;
uniform vec2	NF;

varying vec2 	depth;
	
vec2 ComputeFrame(float dt, vec2 nf)
{
	vec2 ofs=vec2(1.0,1.0)/nf;
	float frame=floor(dt*nf.x*nf.y);
	float row=floor(frame/nf.x);
	float col=floor(frame-nf.x*row);
	
	return vec2(ofs.x*col, 1.0-(ofs.y*row)-ofs.y);
}

vec4 SmoothCurve( vec4 x ) {
  return x * x *( 3.0 - 2.0 * x );
}

vec4 TriangleWave( vec4 x ) {
  return abs( fract( x + 0.5 ) * 2.0 - 1.0 );
}

vec4 SmoothTriangleWave( vec4 x ) {
  return SmoothCurve( TriangleWave( x ) );
}

vec2 XformWind(vec2 wind, mat4 TM)
{
	mat2 TM2;
	TM2[0]=vec2(TM[0].x,TM[2].x);
	TM2[1]=vec2(TM[0].z,TM[2].z);
	return TM2*wind;
}

void main()
{					
#ifdef _HEIGHTMAP_

	// compute position basing on heightmap
	vec4 	position00,
			position10,
			position01;
		
	mat4 MTX;
	vec3 tilepos=WorldPoses[gl_InstanceID];
	texcoord = ((gl_Vertex.xz + tilepos.xz)*invTerrainDim.xz)+vec2(0.5,0.5)+(invHeightmapSize*0.5);
	position00.y=(texture2D(heightmap,texcoord.st).x-0.5)*terrainDim.y;
	position00.xz=gl_Vertex.xz;
	position10.y=(texture2D(heightmap,texcoord.st + vec2(invHeightmapSize.x,0.0)).x-0.5)*terrainDim.y;
	position10.xz=gl_Vertex.xz + vec2(tileDim.x,0.0);
	position01.y=(texture2D(heightmap,texcoord.st + vec2(0.0,invHeightmapSize.y)).x-0.5)*terrainDim.y;
	position01.xz=gl_Vertex.xz + vec2(0.0,tileDim.y);
	
	vec4 position;
	position.xyz=tilepos+position00.xyz;
	position.w=1.0;
	
	// transform position in projection and eye space
	gl_Position = gl_ModelViewProjectionMatrix * position;
	pos=gl_ModelViewMatrix*position;
	
	// compute previous position for motion blur
	mat4 MVP=gl_ProjectionMatrix*prevMVM;
	prev=MVP*position;
	
	// compute normals (convert heightmap into normalmap
	vec3 binormal3=normalize(position00.xyz-position10.xyz);
	vec3 tangent3=normalize(position00.xyz-position01.xyz);
	vec3 normal3=cross(tangent3,binormal3);
	binormal3=cross(normal3,vec3(1.0,0.0,0.0));
	tangent3=cross(binormal3,normal3);
	
	TBN[0]=gl_NormalMatrix*tangent3;
	TBN[1]=gl_NormalMatrix*binormal3;
	TBN[2]=gl_NormalMatrix*normal3;
	
	curpos=gl_Position;
	vColor=texture2D(cmask,texcoord.st).rgb;
	vSlope=abs(dot(normal3,vec3(0.0,1.0,0.0)));
	vSlope=clamp( (vSlope-baseTexParams.x)*baseTexParams.z, 0.0,1.0);
	vSlope*=1.0 - clamp( ((position.y*invTerrainDim.y)-baseTexParams.y)*100.0, 0.0,1.0);
	baseCoords=texcoord.st*baseTiles;
	
#else

	vec4 normal4      	= vec4( gl_Normal.xyz, 0.0 );
	vec4 binormal4      = vec4( binormal.xyz, 0.0 );
	vec4 tangent4      	= vec4(cross(binormal4.xyz,normal4.xyz),0.0);
	binormal4.xyz*=binormal.w;
	#ifdef SKINNING

		vec4 index  		= gl_SecondaryColor;
		vec4 weight 		= gl_Color;
		vec4 position   	= vec4( 0.0, 0.0, 0.0, 0.0 );
		vec4 tempNormal  	= vec4( 0.0, 0.0, 0.0, 0.0 );
		vec4 tempTangent  	= vec4( 0.0, 0.0, 0.0, 0.0 );
		vec4 tempBinormal  	= vec4( 0.0, 0.0, 0.0, 0.0 );
		vec4 prevpos 		= vec4( 0.0, 0.0, 0.0, 0.0 );
		
		mat4 TM=mat4(	0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,1.0);
		mat4 pTM=mat4(	0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,0.0,
						0.0,0.0,0.0,1.0);

		int j;
		for( int i = 0; i < 4; i++ )
		{
			// Apply influence of bone i
			j=int(index[i]*4);
			TM[0].xyz=texelFetchBuffer(boneMatrices,j).xyz;
			TM[1].xyz=texelFetchBuffer(boneMatrices,j+1).xyz;
			TM[2].xyz=texelFetchBuffer(boneMatrices,j+2).xyz;
			TM[3].xyz=texelFetchBuffer(boneMatrices,j+3).xyz;
			
			pTM[0].xyz=texelFetchBuffer(prevBoneMatrices,j).xyz;
			pTM[1].xyz=texelFetchBuffer(prevBoneMatrices,j+1).xyz;
			pTM[2].xyz=texelFetchBuffer(prevBoneMatrices,j+2).xyz;
			pTM[3].xyz=texelFetchBuffer(prevBoneMatrices,j+3).xyz;
			
			//j+=4;
			position = position + (TM * gl_Vertex) *weight[i];
			prevpos = prevpos + ( (pTM*gl_Vertex) * weight[i] );
			
			// Transform normals by bone i
			TM[3]=vec4(0,0,0,1);
			tempNormal = tempNormal + (TM * normal4)*weight[i];
			tempBinormal = tempBinormal + (TM * binormal4)*weight[i];
			tempTangent = tempTangent + (TM * tangent4)*weight[i];
		}
		gl_Position = gl_ModelViewProjectionMatrix * position;
		prevpos=prevMVM*prevpos;
		prev = gl_ProjectionMatrix*prevpos;	
		pos = (gl_ModelViewMatrix * position);

		normal4=tempNormal;
		tangent4=tempTangent;
		binormal4=tempBinormal;
		
		texcoord = gl_MultiTexCoord0.st;
		curpos=gl_Position;	
		
		outNormal=gl_ModelViewMatrix*normal4;
		outTangent=gl_ModelViewMatrix*tangent4;
		outBinormal=gl_ModelViewMatrix*binormal4; 

		normalize(outNormal);
		normalize(outTangent);
		normalize(outBinormal);

		TBN[0]=outTangent.xyz;
		TBN[1]=outBinormal.xyz;
		TBN[2]=outNormal.xyz;
		
	#else

		#ifdef PSYSTEM

			vec4 index=gl_Color;
			vec4 ppos=pparams[int(index.x)];
			life=clamp(ppos.w,0.0,1.0);
			float scale=data.x + (data.y*(1.0-life));
			scale=clamp(scale,0.0,abs(scale))*0.5;
			scale+=scale*index.y;	
			ppos.w=1.0;

			float angle=(index.y*6.28)+(data.z*(1.0-life)*6.28);

			cosa=cos(angle);
			sina=sin(angle);

			tpos=gl_ModelViewMatrix * ppos;	
			
			vec3 tv=gl_Vertex.xyz;
			tv.x=(gl_Vertex.x*cosa)-(gl_Vertex.y*sina);
			tv.y=(gl_Vertex.x*sina)+(gl_Vertex.y*cosa);
			tpos.xyz=(tv.xyz*particleScale*scale + tpos.xyz);

			gl_Position=gl_ProjectionMatrix*tpos;
			texcoord = gl_MultiTexCoord0.st*tscale;

			curpos=gl_Position;		
			pos=tpos;
			
			ppos=prevPParams[int(index.x)];
			scale=data.x + (data.y*(1.0-life));
			scale=clamp(scale,0.0,abs(scale))*0.5;
			scale+=scale*index.y;	
			ppos.w=1.0;

			tpos=prevMVM*ppos;	
			tpos.xyz=(tv.xyz*scale + tpos.xyz);
			prev=gl_ProjectionMatrix*tpos;
			
		#else

			#ifdef BSET

				vec4 index=gl_Color;
				int i=int(index.x)*3;
				vec4 ppos;
				ppos=texelFetchBuffer(pparams,i);
				pcolor=texelFetchBuffer(pparams,i+1);	
				
				////////////////////////////////////////////
				float bend=pcolor.w*gl_Vertex.y;
				vec4 newpos=gl_Vertex;
				#ifdef VEGETATION
					float vlen=length(newpos.xyz);
					float phase=dot(ppos.xyz,vec3(1.0,1.0,1.0));
					newpos.x+=(sin( (freq*5.2)+phase)*0.4 + cos((freq*8.5)+2.0*phase)*0.2 )*bend*bendMul.x*windStrenght;
					newpos.xyz=normalize(newpos.xyz)*vlen;
				#endif
				//////////////////////////////////////
				
				pcolor.w=ppos.w;
				ppos.w=1.0;
				
				normal4=texelFetchBuffer(pparams,i+2);
				float scale=abs(normal4.w)*0.5*index.y;
				
				mat3 PTM;
				PTM[2]=normalize(ppos.xyz-campos);
				PTM[0]=normalize(cross(vec3(0.0,1.0,0.0),PTM[2]));
				PTM[1]=cross(PTM[2],PTM[0]);
				
				vec4 rpos=newpos*scale;
				rpos.xyz=(PTM*rpos.xyz) + ppos.xyz;
				rpos.w=1.0;
				
				tpos=gl_ModelViewMatrix*rpos;
				gl_Position=gl_ProjectionMatrix*tpos;	
				curpos=gl_Position;	
				pos=tpos;
				
				// compute prev pos
				tpos=prevMVM*rpos;
				prev=gl_ProjectionMatrix*tpos;
				
				PTM=mat3(gl_ModelViewMatrix[0].xyz,gl_ModelViewMatrix[1].xyz,gl_ModelViewMatrix[2].xyz);
				pnormal.xyz=PTM * normal4.xyz;
				texcoord = gl_MultiTexCoord0.st;	
		
			#else
			
				#ifdef MSET
					
					vec4 index=gl_Color;
					mat4 mtx=pparams[int(index.w)];
					float bendScale=mtx[3].w;
					mtx[3].w=1.0;
					vec4 newpos=gl_Vertex;
					
					#ifdef VEGETATION
						////////////////////////////////////////////
						vec2 dBend=gl_Color.gb*windStrenght*bendMul.y;
						float phase=dot(mtx[3].xyz,vec3(1.0,1.0,1.0));
						float phase2=phase+gl_Color.r;
						float phase3=phase2+dot(gl_Vertex.xyz,vec3(1.0,1.0,1.0));
						phase2*=3.14;
						phase3*=3.14;
						phase+=freq;
						
						vec4 	waves=sin( vec4( (freq*8.2)+phase3,	(freq*4.0)+phase2, ((freq*13.5)+2.0*phase3)+1.570796, 	((freq*10.0)+phase2*3.0)+1.570796)	);
						vec2 	windMul=sin( vec2(phase, ((phase+1.0)*5.0)+1.570796) );
						
						newpos.xz+=gl_Normal.xy*(waves.x*2.0 + waves.z)*dBend.x;
						newpos.y+=(waves.y + waves.w)*dBend.y;
						
						float vlen=length(gl_Vertex.xyz);
						float bend;
						bend=gl_Vertex.y*bendScale;
						bend += 1.0;
						bend = (bend * bend - bend) * bendMul.x * windStrenght;
						
						vec2 windVector=windVec.xz;//vec2(mtx[1].w,mtx[2].w);
						mtx[1].w=0.0;
						mtx[2].w=0.0;
					
						newpos.xz+=( XformWind(windVector,mtx)/*vec2(mtx[1].w,mtx[2].w)*/ * ((windMul.x+windMul.y)*10.0+30.0)*bend );
						newpos.xyz=normalize(newpos.xyz)*vlen;
						//////////////////////////////////////
					#else
						mtx[1].w=0.0;
						mtx[2].w=0.0;
					#endif
					
					newpos=mtx*newpos;
					tpos=gl_ModelViewMatrix * newpos;	
					gl_Position=gl_ProjectionMatrix*tpos;	
					curpos=gl_Position;	
					pos=tpos;
					
					// compute prev pos
					tpos=prevMVM*newpos;	
					prev=gl_ProjectionMatrix*tpos;
		
					texcoord = gl_MultiTexCoord0.st;	
					
					outNormal=gl_ModelViewMatrix*normal4;
					outTangent=gl_ModelViewMatrix*tangent4;
					outBinormal=gl_ModelViewMatrix*binormal4; 

					TBN[0]=outTangent.xyz;
					TBN[1]=outBinormal.xyz;
					TBN[2]=outNormal.xyz;
					
				#else
			
					#ifndef _NOT_INSTANCED_
					
						mat4 MTX;
						int index=gl_InstanceID*4;
						MTX[0]=texelFetchBuffer(WorldPoses,index);
						MTX[1]=texelFetchBuffer(WorldPoses,index+1);
						MTX[2]=texelFetchBuffer(WorldPoses,index+2);
						MTX[3]=texelFetchBuffer(WorldPoses,index+3);
						
						#ifdef ALPHATEST
							alphaFade=MTX[3].w+0.01;
							MTX[3].w=1.0;
						#endif
						
						mat4 prevMTX;
						prevMTX[0]=texelFetchBuffer(prevWorldPoses,index);
						prevMTX[1]=texelFetchBuffer(prevWorldPoses,index+1);
						prevMTX[2]=texelFetchBuffer(prevWorldPoses,index+2);
						prevMTX[3]=texelFetchBuffer(prevWorldPoses,index+3);
						
						vec4 newpos=gl_Vertex;
						vec4 worldPos;
						
						#ifdef VEGETATION
							
							vec2 dBend=gl_Color.gb*windStrenght*bendMul.y;
							float phase=dot(prevMTX[3].xyz,vec3(1.0,1.0,1.0));
							float phase2=phase+gl_Color.r;
							float phase3=phase2+dot(gl_Vertex.xyz,vec3(1.0,1.0,1.0)/*vec2(phase+phase2)*/);
							phase2*=3.14;
							phase3*=3.14;
							
							vec4 	waves=sin( vec4( (freq*8.2)+phase3,	(freq*4.0)+phase2, ((freq*13.5)+2.0*phase3)+1.570796, 	((freq*10.0)+phase2*3.0)+1.570796)	);
							
							newpos.xz+=gl_Normal.xy*(waves.x*2.0 + waves.z)*dBend.x;
							newpos.y+=(waves.y + waves.w)*dBend.y;
							
							float vlen=length(gl_Vertex.xyz);	
							float bend;
							bend=gl_Vertex.y*meshbox.y;
							bend += 1.0;
							bend = (bend * bend - bend) * bendMul.x * windStrenght;
							
							vec2 windVector=vec2(MTX[1].w,MTX[2].w);
							MTX[1].w=0.0;
							MTX[2].w=0.0;
							newpos.xz+=(XformWind(windVector,MTX)/*vec2(MTX[1].w,MTX[2].w)*/*bend);
							newpos.xyz=normalize(newpos.xyz)*vlen;
							//////////////////////////////////////
						#else	
							MTX[1].w=0.0;
							MTX[2].w=0.0;
						#endif
					
						worldPos=MTX*newpos;
						gl_Position = (gl_ModelViewProjectionMatrix)*worldPos;//ftransform();
						
						pos=gl_ModelViewMatrix*worldPos;
						worldPos=prevMTX*newpos;
						worldPos=prevMVM*worldPos;
						prev=gl_ProjectionMatrix*worldPos;
						texcoord = gl_MultiTexCoord0.st;		
						curpos=gl_Position;
						
						outNormal=MTX*normal4;
						outTangent=MTX*tangent4;
						outBinormal=MTX*binormal4; 
						outNormal=gl_ModelViewMatrix*outNormal;
						outTangent=gl_ModelViewMatrix*outTangent;
						outBinormal=gl_ModelViewMatrix*outBinormal; 
					
					#else
						vec4 newpos=gl_Vertex;
					
						#ifdef VEGETATION
							////////////////////////////////////////////
							vec2 dBend=gl_Color.gb*windStrenght*bendMul.y;
							float phase=dot(prevWTM[3].xyz,vec3(1.0,1.0,1.0));
							float phase2=phase+gl_Color.r;
							float phase3=phase2+dot(gl_Vertex.xyz,vec3(1.0,1.0,1.0)/*vec2(phase+phase2)*/);
							phase2*=3.14;
							phase3*=3.14;
							
							vec4 	waves=sin( vec4( (freq*8.2)+phase3,	(freq*4.0)+phase2, ((freq*13.5)+2.0*phase3)+1.570796, 	((freq*10.0)+phase2*3.0)+1.570796)	);
							
							newpos.xz+=gl_Normal.xy*(waves.x*2.0 + waves.z)*dBend.x;
							newpos.y+=(waves.y + waves.w)*dBend.y;
							
							float vlen=length(gl_Vertex.xyz);			
							float bend;
							bend=gl_Vertex.y*meshbox.y;
							bend += 1.0;
							bend = (bend * bend - bend) * bendMul.x * windStrenght;
							
							vec2 windVector=windVec.xz;
							newpos.xz+=(XformWind(windVector,prevWTM)*bend);
							newpos.xyz=normalize(newpos.xyz)*vlen;
							//////////////////////////////////////
						#else
							
						#endif
						
						gl_Position = (gl_ModelViewProjectionMatrix)*newpos;//ftransform();
						pos=(gl_ModelViewMatrix * newpos);
						
						newpos=prevWTM*newpos;
						newpos=prevMVM*newpos;
						prev=gl_ProjectionMatrix*newpos;
						texcoord = gl_MultiTexCoord0.st;		
						curpos=gl_Position;
						
						outNormal=gl_ModelViewMatrix*normal4;
						outBinormal=gl_ModelViewMatrix*binormal4; 
						outTangent=gl_ModelViewMatrix*tangent4;
						
					#endif

					TBN[0]=outTangent.xyz;
					TBN[1]=outBinormal.xyz;
					TBN[2]=outNormal.xyz;
					
				#endif
			
			#endif
			
		#endif
		
	#endif
	
#endif

#ifdef ALPHATEST
	#ifdef BSET
		float dist=(length(pos)-fade*0.5)/(fade*0.5);//*0.8);
		pcolor.w*=(1.0 - (clamp(dist,0.0,1.0)));
		pcolor.w+=0.01;
		
	#endif
#endif

	//depth=gl_Position.zw;					
}